$Serveur_SMTP = "@serveur_smtp"
$Expediteur = "@adressemail_expediteur"
$Delai_avant_expiration = 21
$Chemin = "C:\scripts\expiration_passwords"
 
$Date = Get-Date

$Verif_Chemin = Test-Path -Path $Chemin
If (!($Verif_Chemin))
{
 Try
    {
        New-Item -ItemType Directory $Chemin -Force
    }
 Catch
    {
        $_ | Out-File ($Chemin + "\" + "Log.txt") -Append
    }
}

$CredObj = ($Chemin + "\" + "Expiration.cred")

$CredObjCheck = Test-Path -Path $CredObj
If (!($CredObjCheck))
    {
        "$Date - INFO: Creation Objet Identifiants" | Out-File ($Chemin + "\" + "Log.txt") -Append
        $Credential = Get-Credential

        $Credential | Export-CliXml -Path $CredObj
    }
 
Write-Host "Importation des identifiants." -ForegroundColor Yellow
$Cred = (Import-CliXml -Path $CredObj)
 
# Rcupration des utilisateurs actifs ayant une expiration de mot de passe et non expirs
"$Date - INFO: Import du Module Active Directory" | Out-File ($Chemin + "\" + "Log.txt") -Append
Import-Module ActiveDirectory
"$Date - INFO: Recuperation des utilisateurs" | Out-File ($Chemin + "\" + "Log.txt") -Append
$users = Get-Aduser -properties Name, PasswordNeverExpires, PasswordExpired, PasswordLastSet, EmailAddress -filter { (Enabled -eq 'True') -and (PasswordNeverExpires -eq 'False') } | Where-Object { $_.PasswordExpired -eq $False }
 
$Duree_vie_password = (Get-ADDefaultDomainPasswordPolicy).MaxPasswordAge
 
# Process Each User for Password Expiry
foreach ($user in $users)
{
 $Name = (Get-ADUser $user | ForEach-Object { $_.Name })
 $emailaddress = $user.emailaddress
 If (!($emailaddress))
    {
        Write-Host "$Name -> pas de boite mail" -ForegroundColor Red
        Try
            {
	            $emailaddress = (Get-ADUser $user -Properties proxyaddresses | Select-Object -ExpandProperty proxyaddresses | Where-Object { $_ -cmatch '^SMTP' }).Trim("SMTP:")
            }
        Catch
            {
 	            $_ | Out-File ($Chemin + "\" + "Log.txt") -Append
            }
        If (!($emailaddress))
            {
 	            Write-Host "$Name n'a pas d'adresse mail!" -ForegroundColor Red
                "$Date - WARNING: Pas d'adresse mail pour $Name" | Out-File ($Chemin + "\" + "Log.txt") -Append
            }
    
    }

 #Date derniere modification du mot de passe
 $Derniere_modif_pass= (Get-ADUser $user -properties * | ForEach-Object { $_.PasswordLastSet })
 $Strategie_password = (Get-ADUserResultantPasswordPolicy $user)
 if (($Strategie_password) -ne $null)
 {
 	$Duree_vie_password = ($Strategie_password).MaxPasswordAge
 }
 
 $Expiration = $Derniere_modif_pass + $Duree_vie_password
 $today = (get-date)
 $jours_restants = (New-TimeSpan -Start $today -End $Expiration).Days
 
 If (($jours_restants -ge "0") -and ($jours_restants -lt $Delai_avant_expiration))
 {
 "$Date - INFO: Sending expiry notice email to $Name" | Out-File ($Chemin + "\" + "Log.txt") -Append
 Write-Host "Sending Password expiry email to $name" -ForegroundColor Yellow
 
 $SmtpClient = new-object system.net.mail.smtpClient
 $MailMessage = New-Object system.net.mail.mailmessage
 
 #Expediteur
 $mailmessage.From = $Expediteur

 #Serveur SMTP
 $SmtpClient.Host = $Serveur_SMTP

 #SMTP SSL
 #$SMTPClient.EnableSsl = $true

 #Identifiants pourl'authentification SMTP
 $SMTPClient.Credentials = $cred

 #Destinataire
 $mailmessage.To.add("$emailaddress")

 #Objet de l'email
 $mailmessage.Subject = "Expiration de votre mot de passe dans $jours_restants jours"

 #Notification de remise
 $MailMessage.DeliveryNotificationOptions = ("onSuccess", "onFailure")

 #Envoi du mail en priorit lev
 $MailMessage.Priority = "High"

 #Contenu de l'email
 $mailmessage.Body =
 "$Name,

Votre mot de passe de session expirera dans $jours_restants jours. Veuillez le changer rapidement
 
Pour cela, veuillez suivre la procdure qui suit:
 
 b.	Pressez Ctrl-Alt-Suppr et cliquez sur 'Modifier un mot de passe'
 d.	Saisissez votre mot de passe actuel et 2 fois le nouveau
 e.	Cliquez sur la flche pour valider la modification

 
Pour toute question merci de nous contacter sur @adressemail_support_IT
 
Cordialement,"

 Write-Host "Envoi E-mail  $emailaddress..." -ForegroundColor Green
 Try
 {
 $smtpclient.Send($mailmessage)
 }
 Catch
 {
 $_ | Out-File ($Chemin + "\" + "Log.txt") -Append
 }
 }
 Else
 {
 "$Date - INFO:  $Name expirera dans $jours_restants jours" | Out-File ($Chemin + "\" + "Log.txt") -Append
 Write-Host "Le mot de passe de $Name expirera dans $jours_restants jours" -ForegroundColor White
 }
}"msDS-UserPasswordExpiryTimeComputed" | Select-Object -Property "Displayname",@{Name="ExpiryDate";Expression={[datetime]::FromFileTime($_."msDS-UserPasswordExpiryTimeComputed")}}