
Param(
[string]$SearchBase = "DC=domaine,DC=local",
[string]$ADServer = "DC01",
[string]$ExportBasePath='.\',
[string]$ReportName="AdReport",
[int]$DaysInactive = 0,
[switch]$HideDisabled = $false
)

Import-Module ActiveDirectory

Write-Host "Recuperation des utilisateurs"
$AllADUsers = Get-ADUser -server $ADServer -searchbase $SearchBase -Filter * -Properties *
$FilteredAllADUsers = @()
$now = Get-Date

foreach($val in $AllADUsers){
    if($DaysInactive -gt 0){
        if($val.lastlogondate -and (($now-$val.lastlogondate).TotalDays -le $DaysInactive)){
            continue;
        }
    }
    if($HideDisabled){
        if(!$val.Enabled){
            continue
        }
    }
    $FilteredAllADUsers += $val
}

Write-Host "Traitement des utilisateurs"
$data = $FilteredAllADUsers |
Select-Object @{Label = "Compte";Expression = {$_.sAMAccountName}},
@{Label = "Prenom";Expression = {$_.GivenName}},
@{Label = "Nom";Expression = {$_.Surname}},
@{Label = "Nom Affichage";Expression = {$_.DisplayName}},
@{Label = "Email";Expression = {$_.Mail}},
@{Label = "Bals Outlook";Expression = {""}},
@{Label = "Etat Compte";Expression = {if (($_.Enabled -eq 'TRUE')  ) {'Actif'} Else {'Desactive'}}}, # the 'if statement# replaces $_.Enabled
@{Label = "Derniere Connexion Compte";Expression = {$_.lastlogondate}}|Sort Compte


#Export CSV report

Write-Host "Export"

$ExportPath = $ExportBasePath+"\$ReportName.csv"
$data | Export-Csv -Path $ExportPath -NoTypeInformation -Delimiter ";" -Encoding UTF8

$Header = @"
<style>
TABLE {border-width: 1px; border-style: solid; border-color: black; border-collapse: collapse;}
TH {border-width: 1px; padding: 3px; border-style: solid; border-color: black; background-color: #6495ED;}
TD {border-width: 1px; padding: 3px; border-style: solid; border-color: black;}
</style>
"@

$ExportPath = $ExportBasePath+"\$ReportName.html"
Write-Host "Export To : $ExportPath"
$Data|ConvertTo-Html -Property * -Head $Header | Out-File -FilePath $ExportPath -Encoding UTF8
